#!/bin/bash
pushd `dirname $0` > /dev/null
if [ "$1" = "--help" ]; then
    echo "Usage: $0 [--php72] [TEST_ARGUMENTS]"
    echo ""
    echo "One can pass additional arguments to the testing framework using TEST_ARGUMENTS, for example:"
    echo ""
    echo "  $0 --group failing"
    echo "  $0 --testsuite FunctionalTests"
    echo ""
    popd > /dev/null
    exit
fi
PHPUNIT_BIN="../vendor/bin/phpunit"
PHPUNIT_XML="../phpunit.xml"
if [ ! -e "$PHPUNIT_BIN" ]; then
    echo "ERROR: Could not find PHPUnit executable at $PHPUNIT_BIN"
    popd > /dev/null
    exit
fi
if [ ! -e "$PHPUNIT_XML" ]; then
    echo "ERROR: Could not find PHPUnit configuration at $PHPUNIT_XML"
    popd > /dev/null
    exit
fi
echo "Running PHPUnit tests..."
echo ""
if [ "$1" = "--php72" ]; then
    ./php72.sh ./vendor/bin/phpunit -c phpunit.xml "${@:2}"
elif [ "$1" = "--php74" ]; then
    ./php74.sh ./vendor/bin/phpunit -c phpunit.xml "${@:2}"
else
    ./php82.sh ./vendor/bin/phpunit -c phpunit.xml "${@:2}"
fi
echo ""
echo "PHPUnit tests done."
popd > /dev/null
