<?php

namespace FCAPoland\ApiPrivacyHelper\Disclaimer;


use FCAPoland\ApiPrivacyHelper\Disclaimer;

/**
 * Class Agreements
 * @package FCAPoland\ApiPrivacyHelper\Disclaimer
 */
class Agreements
{

    /**
     * @var array
     */
    private $disclaimer;

    /**
     * Agreements constructor.
     * @param $disclaimer
     */
    public function __construct(Disclaimer $disclaimer)
    {
        $this->disclaimer = $disclaimer->getDisclaimerArray();
    }

    /**
     * @return string
     */
    public function getIntroduction()
    {
        return (isset($this->getAgreements()['introduction']) ? $this->getAgreements()['introduction'] : '');
    }

    private function getAgreements()
    {
        return (isset($this->disclaimer['agreements']) ? $this->disclaimer['agreements'] : []);
    }

    /**
     * @return array
     */
    public function requiredFields()
    {
        $required_fields = [];
        foreach ($this->getFormElements() as $form_element) {
            foreach ($form_element['inputs'] as $input) {
                if (
                    (isset($form_element['required']) and $form_element['required']) or
                    (isset($input['required']) and $input['required'])
                ) {
                    if (strpos($input['name'], '[]') !== false) {
                        $required_fields[str_replace('[]', '', $input['name'])][] = $input['value'];
                    } else {
                        if (!in_array($input['name'], $required_fields)) {
                            $required_fields[] = $input['name'];
                        }
                    }
                }
            }
        }
        return $required_fields;
    }

    /**
     * @return array
     */
    public function getFormElements()
    {
        return (isset($this->getAgreements()['form_elements']) ? $this->getAgreements()['form_elements'] : []);
    }
}