<?php

namespace Tests\Unit;

use FCAPoland\ApiPrivacyHelper\Cache\MemoryCache;
use FCAPoland\ApiPrivacyHelper\Exception;
use FCAPoland\ApiPrivacyHelper\PrivacyHelper;
use PHPUnit\Framework\TestCase;

/**
 * Class DisclaimerTest
 * @package Tests\Unit
 */
class DisclaimerDisclaimerID extends TestCase
{

    /**
     * @param $disclaimer_id
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testGetID($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id);
        $this->assertEquals(
            $disclaimer_id,
            $privacy_helper->getDisclaimer()->getDisclaimerID()
        );
    }

    /**
     * @param $disclaimer_id
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testGetArray($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id);
        $this->assertInternalType(
            'array',
            $privacy_helper->getDisclaimer()->getDisclaimerArray()
        );
    }


    /**
     * @param $disclaimer_id
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerCreateAgreementsObject($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id);
        $privacy_helper->setcache(new MemoryCache());

        $this->assertInstanceOf('\FCAPoland\ApiPrivacyHelper\Disclaimer\Agreements', $privacy_helper->getDisclaimer()->getAgreements());
    }

    /**
     * @param $disclaimer_id
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerGetAgreementsFormElements($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id);

        $this->assertInternalType('array', $privacy_helper->getDisclaimer()->getAgreements()->getFormElements());
    }

    /**
     * @param $disclaimer_id
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerGetAgreements($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id);

        $this->assertInternalType('string', $privacy_helper->getDisclaimer()->getAgreements()->getIntroduction());
    }

    /**
     * @param $disclaimer_id
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerCreateGetRequiredFields($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id);

        $this->assertInternalType('array', $privacy_helper->getDisclaimer()->getAgreements()->requiredFields());
    }

    /**
     * @param $disclaimer_id
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerCreateInformactionObject($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id);
        $privacy_helper->setcache(new MemoryCache());

        $this->assertInstanceOf('\FCAPoland\ApiPrivacyHelper\Disclaimer\Information', $privacy_helper->getDisclaimer()->getInformation());
    }

    /**
     * @param $disclaimer_id
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerGetInformactions($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id);
        $privacy_helper->setcache(new MemoryCache());

        $this->assertInternalType('array', $privacy_helper->getDisclaimer()->getInformation()->getInformations());
    }

    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    public function testDisclaimerGetInformactionsKeys()
    {
        $privacy_helper = new PrivacyHelper(723); // privacy-notes
        $privacy_helper->setcache(new MemoryCache());

        $this->assertInternalType('array', $privacy_helper->getDisclaimer()->getInformation()->getInformationKeys());
    }

    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    public function testDisclaimerGetInformactionsPrivacyNotes()
    {
        $privacy_helper = new PrivacyHelper(723); // privacy-notes
        $privacy_helper->setcache(new MemoryCache());

        $this->assertInternalType('string', $privacy_helper->getDisclaimer()->getInformation()->getInformation('privacy-notes'));
    }

    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    public function testDisclaimerExceptionForIncorrectID()
    {
        $this->expectException(Exception::class);
        $privacy_helper = new PrivacyHelper(000);
        $privacy_helper->setcache(new MemoryCache());
    }

    /**
     * @return array
     */
    public function additionProviderDataDisclaimers()
    {
        return [
            [723],
            [358],
            [645],
            [760]
        ];
    }
}
