<?php

namespace FCAPoland\ApiPrivacyHelper\Disclaimer;


use FCAPoland\ApiPrivacyHelper\Disclaimer;

/**
 * Class Agreements
 * @package FCAPoland\ApiPrivacyHelper\Disclaimer
 */
class Agreements
{
    /**
     * @var array
     */
    private $disclaimer;

    /**
     * Agreements constructor.
     * @param $disclaimer
     */
    public function __construct(Disclaimer $disclaimer)
    {
        $this->disclaimer = $disclaimer->getDisclaimerArray();
    }

    /**
     * @return string
     */
    public function getIntroduction()
    {
        return (isset($this->getAgreements()['introduction']) ? $this->getAgreements()['introduction'] : '');
    }

    private function getAgreements()
    {
        return (isset($this->disclaimer['agreements']) ? $this->disclaimer['agreements'] : []);
    }

    /**
     * @return array
     */
    public function requiredFields()
    {
        $required_fields = [];
        foreach ($this->getFormElements() as $form_element) {
            foreach ($form_element['inputs'] as $input) {
                if (
                    (isset($form_element['required']) and $form_element['required']) or
                    (isset($input['required']) and $input['required'])
                ) {
                    if (!in_array($input['name'], $required_fields)) {
                        $required_fields[] = $input['name'];
                    }
                }
            }
        }
        return $required_fields;
    }

    /**
     * @return array
     */
    public function agreementsMapper()
    {
        $map = [];
        foreach ($this->getFormElements() as $form_element) {
            foreach ($form_element['inputs'] as $input) {
                if ($form_element['type'] == 'checkbox') {
                    $map[$input['name']] = $input['maps_to'];
                } elseif ($form_element['type'] == 'radio') {
                    if (!in_array($input['name'], $map)) {
                        $map[$input['name']] = $form_element['maps_to'];
                    }
                }
            }
        }
        return $map;
    }

    /**
     * @param $name
     * @return mixed|null
     */
    public function getAgreementForField($name)
    {
        return (isset($this->agreementsMapper()[$name]) ? $this->agreementsMapper()[$name] : NULL);
    }

    /**
     * @return array
     */
    public function getFormElements()
    {
        return (isset($this->getAgreements()['form_elements']) ? $this->getAgreements()['form_elements'] : []);
    }
}