#!/usr/bin/env sh
pushd `dirname $0` > /dev/null
if [ "$1" == "--help" ]; then
    echo "Usage: $0 [TEST_ARGUMENTS]"
    echo ""
    echo "One can pass additional arguments to the testing framework using TEST_ARGUMENTS, for example:"
    echo ""
    echo "  $0 --group failing"
    echo "  $0 --testsuite FunctionalTests"
    echo ""
    popd > /dev/null
    exit
fi
PHPUNIT_BIN="./vendor/bin/phpunit"
PHPUNIT_XML="./phpunit.xml"
if [ ! -e "$PHPUNIT_BIN" ]; then
    echo "ERROR: Could not find PHPUnit executable at $PHPUNIT_BIN"
    popd > /dev/null
    exit
fi
if [ ! -e "$PHPUNIT_XML" ]; then
    echo "ERROR: Could not find PHPUnit configuration at $PHPUNIT_XML"
    popd > /dev/null
    exit
fi
echo "Running PHPUnit tests..."
echo ""
if [ "$1" == "--docker" ]; then
    ./php56.sh ./vendor/bin/phpunit -c phpunit.xml "${@:2}"
else
    php ./vendor/bin/phpunit -c phpunit.xml "$@"
fi
echo ""
echo "PHPUnit tests done."
popd > /dev/null
