FCA-Poland ApiPrivacyHelper
=================

Helping generate and validate privacy agreements.

Simple usage by example:

1. Include the library in your project:

   `$ composer require fca-poland/privacy-api-helper`

2. Use it:

Basic usage:    
    
    <?php
    require_once "vendor/autoload.php"; 
    $privacy_helper = new PrivacyHelper(723); // id zestawu zgód 
    
    $privacy_helper->setCache(CacheInterface $cache);
    
    $privacy_helper->getDisclaimerID();// Return DisclaimerID
        
       
Privacy policy:


    <?php
    require_once "vendor/autoload.php"; 
    $privacy_helper = new PrivacyHelper(723); // id zestawu zgód 
    
    $privacy_helper->setCache(CacheInterface $cache);
    
    // Get privacy hash (general privacy policy hash)
    $privacy_hash = $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyHash();
    
    // get privacy content  (general privacy policy)
    $privacy = $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent();
    
    // Set new privacy hash
    $privacy_helper->getPrivacyPolicy()->setPrivacyPolicyHash('xyz');
    
    // Get privacy hash (custom privacy policy hash)
    $privacy_hash = $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyHash();
    
    // get privacy content  (custom privacy policy)
    $privacy = $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent();
    
   
    // clear cache for policy only
    $privacy_helper->getPrivacyPolicy()->clearCache();
    
    
    
    
 
Development
-----------

> For Docker development environment see next section.

1. Instal development dependencies:

    `$ composer install --dev`

2. Checkout to development branch:

    `$ git checkout -b dev/feature-1`

3. Do the development (remember about tests!)
4. Make your code better - for lazy programmers:

    ```
    $ ./sniff-the-code-fixer.sh
    ```  
 
5. Sniff the code and detect mess:

    ```
    $ ./sniff-the-code.sh
    $ ./detect-mess.sh
    ``` 
6. Test:

       $ php ./vendor/bin/phpunit
        
   Note that there are currently two testsuites: `Unit` and `Functional`. To use only single testsuite use `--testsuite` param like follows:

        $ ./test.sh --testsuite Unit
   
7. Merge or create merge request.
8. Be happy PHP developer!