<?php

namespace Tests\Unit;

use FCAPoland\ApiPrivacyHelper\Cache\MemoryCache;
use FCAPoland\ApiPrivacyHelper\Exception;
use FCAPoland\ApiPrivacyHelper\PrivacyHelper;
use PHPUnit\Framework\TestCase;

/**
 * Class PrivacyHelperTest
 * @package Tests\Unit
 */
class PrivacyHelperTest extends TestCase
{

    /**
     * @param $disclaimer_id
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testSetDisclaimerID($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id);

        $this->assertEquals(
            $disclaimer_id,
            $privacy_helper->getDisclaimerID()
        );
    }

    /**
     * @param $disclaimer_id
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testCreate($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id);

        $this->assertInternalType('int', $privacy_helper->getDisclaimerID());
    }

    /**
     * @param $disclaimer_id
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerCreateObject($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id);
        $privacy_helper->setcache(new MemoryCache());

        $this->assertInstanceOf('\FCAPoland\ApiPrivacyHelper\Disclaimer', $privacy_helper->getDisclaimer());
    }

    /**
     * @return array
     */
    public function additionProviderDataDisclaimers()
    {
        return [
            [723],
            [358],
            [645],
            [760]
        ];
    }
}
