<?php

namespace FCAPoland\ApiPrivacyHelper;

/**
 * Class Storage
 * @package FCAPoland\ApiPrivacyHelper
 */
class Storage
{
    const STORAGE_FILE = 'helpers_cache/privacy_helper_storage';

    private $storage;

    /**
     * Storage constructor.
     * @throws Exception
     */
    public function __construct()
    {
        if (!file_exists(self::STORAGE_FILE)) {
            $this->createStorageFile();
        }
        $this->readStorage();
    }

    /**
     * @param $id
     * @param $data
     */
    public function saveDisclaimer($id, $data)
    {
        $this->storage['disclaimer'][$id] = $data;
        $this->saveStorage();
    }

    /**
     * @param $id
     * @return mixed
     */
    public function getDisclaimer($id)
    {
        if (!isset($this->storage['disclaimer'][$id])) {
            return false;
        }
        return $this->storage['disclaimer'][$id];
    }

    /**
     * @param $hash
     * @param $data
     */
    public function savePrivacyPolicy($hash, $data)
    {
        $this->storage['privacy_policy'][$hash] = $data;
        $this->saveStorage();
    }

    /**
     * @param $hash
     * @return mixed
     */
    public function getPrivacyPolicy($hash)
    {
        if (!isset($this->storage['privacy_policy'][$hash])) {
            return false;
        }
        return $this->storage['privacy_policy'][$hash];
    }

    /**
     * @throws Exception
     */
    private function readStorage()
    {
        $storage_file = file_get_contents(self::STORAGE_FILE);
        if ($storage_file === false) {
            throw new Exception('Can not read storage file');
        }
        if (strlen($storage_file) == 0) {
            $this->storage = [];
        }
        $this->storage = json_decode($storage_file, true);
    }

    /**
     * Save to storage file
     */
    private function saveStorage()
    {
        if (!is_array($this->storage)) {
            $this->storage = [];
        }
        $json_storage = json_encode($this->storage);
        file_put_contents(self::STORAGE_FILE, $json_storage, LOCK_EX);
    }

    /**
     * Create storage file if not exists
     */
    private function createStorageFile()
    {
        if (!file_exists(self::STORAGE_FILE)) {
            $storage_file = fopen(self::STORAGE_FILE, 'w');
            fclose($storage_file);
            chmod(self::STORAGE_FILE, 0775);
        }
    }

    /**
     * @throws Exception
     */
    public static function removeStorage()
    {
        try {
            if (file_exists(self::STORAGE_FILE)) {
                unlink(self::STORAGE_FILE);
            }
        } catch (Exception $e) {
            throw new Exception('Can not remove storage file');
        }
    }
}
