<?php

namespace Tests\Unit;

use FCAPoland\ApiPrivacyHelper\Storage;
use PHPUnit\Framework\TestCase;

/**
 * Class StorageTest
 * @package Tests\Unit
 */
class StorageTest extends TestCase
{
    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     */
    public function testGeneralStorage()
    {
        $storage = new Storage();
        $storage->savePrivacyPolicy('abc', 'ABC');

        $this->assertInternalType('string', $storage->getPrivacyPolicy('abc'));
    }

    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     */
    public function testGeneralStorage2()
    {
        $storage = new Storage();

        $this->assertInternalType('string', $storage->getPrivacyPolicy('abc'));
    }

    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     */
    public function testGeneralStorage3()
    {
        $storage = new Storage();

        $this->assertInternalType('bool', $storage->getPrivacyPolicy('no_data'));
    }

    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     */
    public function testGeneralStorage4()
    {
        $storage = new Storage();
        $storage->saveDisclaimer('abc', 'ABC');

        $this->assertInternalType('string', $storage->getDisclaimer('abc'));
    }

    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     */
    public function testGeneralStorage5()
    {
        $storage = new Storage();

        $this->assertInternalType('string', $storage->getDisclaimer('abc'));
    }

    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     */
    public function testGeneralStorage6()
    {
        $storage = new Storage();

        $this->assertInternalType('bool', $storage->getDisclaimer('no_data'));
    }

    /**
     * @param $hash
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @dataProvider additionProviderDataIDs
     */
    public function testGeneral($key, $value)
    {
        $storage = new Storage();
        $storage->savePrivacyPolicy($key, $value);

        $this->assertInternalType('string', $storage->getPrivacyPolicy($key));
    }

    /**
     * @param $hash
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @dataProvider additionProviderDataPPHashs
     */
    public function testGeneral2($hash, $value)
    {
        $storage = new Storage();
        $storage->saveDisclaimer($hash, $value);

        $this->assertInternalType('string', $storage->getPrivacyPolicy($hash));
    }

    /**
     * @param $hash
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @dataProvider additionProviderDataIDs
     */
    public function testGeneral3($key, $value)
    {
        $storage = new Storage();

        $this->assertInternalType('string', $storage->getPrivacyPolicy($key));
    }

    /**
     * @param $hash
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @dataProvider additionProviderDataPPHashs
     */
    public function testGeneral4($hash, $value)
    {
        $storage = new Storage();

        $this->assertInternalType('string', $storage->getPrivacyPolicy($hash));
    }

    /**
     * @param $hash
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @dataProvider additionProviderDataIDs
     */
    public function testGeneral5($id, $value)
    {
        $storage = new Storage();

        $this->assertInternalType('string', $storage->getPrivacyPolicy($id));
    }

    /**
     * @param $hash
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @dataProvider additionProviderDataPPHashs
     */
    public function testGeneral6($hash, $value)
    {
        Storage::removeStorage();
        $storage = new Storage();
        $this->assertInternalType('bool', $storage->getPrivacyPolicy($hash));
    }

    /**
     * @param $id
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @dataProvider additionProviderDataIDs
     */
    public function testGeneral7($id, $value)
    {
        Storage::removeStorage();
        $storage = new Storage();
        $this->assertInternalType('bool', $storage->getDisclaimer($id));
    }

    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     */
    public function testGeneral8()
    {
        Storage::removeStorage();
        Storage::removeStorage();
    }

    /**
     * @return array
     */
    public function additionProviderDataPPHashs()
    {
        return [
            ['22c68927b19e818e92067657b89f634509ed7385', 'XXX'],
            ['mBTRP8Bvn2JXveCyOmC8oGRYFdghAu2jdyLwhHAA', 'YYY'],
            ['43a3bacb1a1268127c7b60f52b1f8675793007c0', 'ZZZ']
        ];
    }

    /**
     * @return array
     */
    public function additionProviderDataIDs()
    {
        return [
            ['001', 'XXX'],
            ['002', 'YYY'],
            ['003', 'ZZZ']
        ];
    }
}