<?php

namespace FCAPoland\ApiPrivacyHelper;

use Psr\SimpleCache\CacheInterface;

/**
 * Class PrivacyHelper
 * @package FCAPoland\ApiPrivacyHelper
 */
class PrivacyHelper
{
    const PRIVACY_HELPER_CACHE_KEY = 'fca_poland_privacy_helper';

    /**
     * @var CacheInterface
     */
    private $cache;

    /**
     * @var int
     */
    private $disclaimer_id;

    /**
     * @var PrivacyPolicy
     */
    private $privacy_policy;

    /**
     * @var Disclaimer
     */
    private $disclaimer;

    /**
     * Disclaimer constructor.
     * @param int $disclaimer_id
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    public function __construct($disclaimer_id, $storage_file = null)
    {
        $this->disclaimer_id = $disclaimer_id;
        $this->disclaimer = new Disclaimer($disclaimer_id, $storage_file);
        $this->privacy_policy = new PrivacyPolicy($storage_file);
    }

    /**
     * @return Integer
     */
    public function getDisclaimerID()
    {
        return $this->disclaimer_id;
    }

    /**
     * Attaches cache
     *
     * @param CacheInterface $cache
     */
    public function setcache(CacheInterface $cache)
    {
        $this->cache = $cache;
        $this->privacy_policy->setCache($this->cache);
        $this->disclaimer->setCache($this->cache);
    }

    /**
     * @return PrivacyPolicy
     */
    public function getPrivacyPolicy()
    {
        return $this->privacy_policy;
    }

    /**
     * @return Disclaimer
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    public function getDisclaimer()
    {
        return $this->disclaimer->getDisclaimer();
    }
}
