<?php

namespace Tests\Functional;

use FCAPoland\ApiPrivacyHelper\Cache\MemoryCache;
use FCAPoland\ApiPrivacyHelper\PrivacyHelper;

class PrivacyHelperTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var int
     */
    private $disclaimer_id;

    /**
     * @var MemoryCache
     */
    private $cache;

    /**
     * @param $disclaimer_id
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testMain($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id);
        $this->assertEquals(
            $disclaimer_id,
            $privacy_helper->getDisclaimer()->getDisclaimerID()
        );
    }

    /**
     * @param $disclaimer_id
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testMain2($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, 'helpers_cache/privacy_helper_storage2');
        $this->assertEquals(
            $disclaimer_id,
            $privacy_helper->getDisclaimer()->getDisclaimerID()
        );
    }

    /**
     * @return array
     */
    public function additionProviderDataDisclaimers()
    {
        return [
            [723],
            [358],
            [645]
        ];
    }

    protected function setUp()
    {
        parent::setUp();

        $this->disclaimer_id = 723;
        $this->cache = new MemoryCache();
    }
}
