<?php

namespace Tests\Unit;

use FCAPoland\ApiPrivacyHelper\Cache\MemoryCache;
use FCAPoland\ApiPrivacyHelper\PrivacyHelper;
use PHPUnit\Framework\TestCase;

/**
 * Class PrivacyPolicyTest
 * @package Tests\Unit
 */
class PrivacyPolicyTest extends TestCase
{
    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    public function testGeneralPrivacyPolicyHash()
    {
        $privacy_helper = new PrivacyHelper(723);

        $this->assertInternalType('string', $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyHash());
    }

    /**
     * @param $hash
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataPPHashs
     */
    public function testSetPolicyHash($hash)
    {
        $privacy_helper = new PrivacyHelper(723);
        $privacy_helper->getPrivacyPolicy()->setPrivacyPolicyHash($hash);
        $this->assertEquals(
            $hash,
            $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyHash()
        );
    }

    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    public function testGeneralPrivacyPolicyContent()
    {
        $privacy_helper = new PrivacyHelper(723);

        $this->assertInternalType('string', $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent());
    }

    /**
     * @param $hash
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataPPHashs
     */
    public function testCustomPrivacyPolicyHash($hash)
    {
        $privacy_helper = new PrivacyHelper(723);
        $privacy_helper->getPrivacyPolicy()->setPrivacyPolicyHash($hash);

        $this->assertInternalType('string', $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyHash());
    }

    /**
     * @param $hash
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataPPHashs
     */
    public function testCustomPrivacyPolicyContent($hash)
    {
        $privacy_helper = new PrivacyHelper(723);
        $privacy_helper->getPrivacyPolicy()->setPrivacyPolicyHash($hash);

        $this->assertInternalType('string', $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent());
    }

    /**
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    public function testGeneralPrivacyPolicyContentWithCache()
    {
        $privacy_helper = new PrivacyHelper(723);
        $privacy_helper->setcache(new MemoryCache());

        $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent();

        $this->assertInternalType('string', $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent());
    }

    /**
     * @param $hash
     * @throws \FCAPoland\ApiPrivacyHelper\Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     * @dataProvider additionProviderDataPPHashs
     */
    public function testCustomPrivacyPolicyContentWithCache($hash)
    {
        $privacy_helper = new PrivacyHelper(723);
        $privacy_helper->setcache(new MemoryCache());

        $privacy_helper->getPrivacyPolicy()->setPrivacyPolicyHash($hash);
        $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent();

        $this->assertInternalType('string', $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent());
    }

    /**
     * @return array
     */
    public function additionProviderDataPPHashs()
    {
        return [
            ['22c68927b19e818e92067657b89f634509ed7385'],
            ['mBTRP8Bvn2JXveCyOmC8oGRYFdghAu2jdyLwhHAA'],
            ['43a3bacb1a1268127c7b60f52b1f8675793007c0']
        ];
    }
}
