<?php
declare(strict_types=1);


namespace FCAPoland\ApiPrivacyHelper\Disclaimer;

use FCAPoland\ApiPrivacyHelper\Disclaimer;

/**
 * Class Information
 * @package FCAPoland\ApiPrivacyHelper\Disclaimer
 */
class Information
{
    /**
     * @var array
     */
    private $disclaimer;

    /**
     * Information constructor.
     * @param $disclaimer
     */
    public function __construct(Disclaimer $disclaimer)
    {
        $this->disclaimer = $disclaimer->getDisclaimerArray();
    }

    /**
     * @param $key
     * @return string
     */
    public function getInformation($key)
    {
        return $this->getInformations()[$key] ?? '';
    }

    /**
     * @return array
     */
    public function getInformations()
    {
        return $this->disclaimer['information'] ?? [];
    }

    /**
     * @param $key
     * @return bool
     */
    public function hasInformation($key)
    {
        return isset($this->getInformations()[$key]);
    }

    /**
     * @return array
     */
    public function getInformationKeys()
    {
        return array_keys($this->getInformations());
    }
}
