<?php

namespace Tests\Unit;

use FCAPoland\ApiPrivacyHelper\Cache\MemoryCache;
use FCAPoland\ApiPrivacyHelper\Exception;
use FCAPoland\ApiPrivacyHelper\PrivacyHelper;
use FCAPoland\ApiPrivacyHelper\Storage;
use FCAPoland\ApiPrivacyHelper\StorageInterface;
use PHPUnit\Framework\TestCase;
use Psr\SimpleCache\InvalidArgumentException;

/**
 * Class PrivacyHelperTest
 * @package Tests\Unit
 */
class PrivacyHelperTest extends TestCase
{
    /**
     * @var StorageInterface
     */
    private $storage;

    /**
     * @param $disclaimer_id
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testSetDisclaimerID($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);

        $this->assertEquals(
            $disclaimer_id,
            $privacy_helper->getDisclaimerID()
        );
    }

    /**
     * @param $disclaimer_id
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testCreate($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);

        $this->assertIsInt($privacy_helper->getDisclaimerID());
    }

    /**
     * @param $disclaimer_id
     * @throws Exception
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerCreateObject($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);
        $privacy_helper->setcache(new MemoryCache());

        $this->assertInstanceOf('\FCAPoland\ApiPrivacyHelper\Disclaimer', $privacy_helper->getDisclaimer());
    }

    /**
     * @return array
     */
    public function additionProviderDataDisclaimers()
    {
        return [
            [723],
            [358],
            [645],
            [760]
        ];
    }

    protected function setUp(): void
    {
        parent::setUp();
        $this->storage = new Storage();
    }
}
