<?php
declare(strict_types=1);


namespace FCAPoland\ApiPrivacyHelper;

use FCAPoland\ApiPrivacyHelper\Exception\PrivacyHelperException;
use Psr\SimpleCache\CacheInterface;
use Psr\SimpleCache\InvalidArgumentException;

/**
 * Class PrivacyHelper
 * @package FCAPoland\ApiPrivacyHelper
 */
class PrivacyHelper
{
    const PRIVACY_HELPER_CACHE_KEY = 'fca_poland_privacy_helper';

    /**
     * @var int
     */
    private $disclaimer_id;

    /**
     * @var PrivacyPolicy
     */
    private $privacy_policy;

    /**
     * @var Disclaimer
     */
    private $disclaimer;

    /**
     * PrivacyHelper constructor.
     * @param $disclaimer_id
     * @param StorageInterface $storage
     */
    public function __construct($disclaimer_id, StorageInterface $storage)
    {
        $this->disclaimer_id = $disclaimer_id;
        $this->disclaimer = new Disclaimer($disclaimer_id, $storage);
        $this->privacy_policy = new PrivacyPolicy($storage);
    }

    /**
     * @return int
     */
    public function getDisclaimerID(): int
    {
        return $this->disclaimer_id;
    }

    /**
     * Attaches cache
     *
     * @param CacheInterface $cache
     */
    public function setCache(CacheInterface $cache)
    {
        $this->privacy_policy->setCache($cache);
        $this->disclaimer->setCache($cache);
    }

    /**
     * @return PrivacyPolicy
     */
    public function getPrivacyPolicy(): PrivacyPolicy
    {
        return $this->privacy_policy;
    }

    /**
     * @return Disclaimer
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     */
    public function getDisclaimer(): Disclaimer
    {
        return $this->disclaimer->getDisclaimer();
    }
}
