FCA-Poland ApiPrivacyHelper
=================

Helping generate and validate privacy agreements.

Simple usage by example:

1. Include the library in your project:

   `$ composer require fca-poland/privacy-api-helper`

2. Use it:

Basic usage:    
    
    <?php
    require_once "vendor/autoload.php"; 
    $privacy_helper = new PrivacyHelper(723); // id zestawu zgód
    // przykład zmiany celu zapytań HTTP (domyślnie jest to `https://api.fcapoland.pl/`)
    $privacy_helper->setApiBaseUrl('http://localhost/');
    
    $privacy_helper->setCache(CacheInterface $cache);
    
    $privacy_helper->getDisclaimerID();// Return DisclaimerID
        
       
Privacy policy:


    <?php
    require_once "vendor/autoload.php"; 
    $privacy_helper = new PrivacyHelper(723, new Storage('dir/to/storage/file')); // id zestawu zgód
    $privacy_helper->setApiBaseUrl('https://testapi.fcapoland.pl/'); // przykład zmiany celu zapytań HTTP na testowe API
    
    $privacy_helper->setCache(CacheInterface $cache);
    
    // Get privacy hash (general privacy policy hash)
    $privacy_hash = $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyHash();
    
    // get privacy content  (general privacy policy)
    $privacy = $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent();
    
    // Set new privacy hash
    $privacy_helper->getPrivacyPolicy()->setPrivacyPolicyHash('xyz');
    
    // Get privacy hash (custom privacy policy hash)
    $privacy_hash = $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyHash();
    
    // get privacy content  (custom privacy policy)
    $privacy = $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent();
    
   
    // clear cache for policy only
    $privacy_helper->getPrivacyPolicy()->clearCache();
    
    
    
    
 
Development
-----------

1. Docker utilities are available through `docker-compose`:

    $ docker-compose build

2. Instal development dependencies:

    `$ ./docker/php74.sh composer.phar install --dev`

3. Checkout to development branch:

    `$ git checkout -b dev/feature-1`

4. Do the development (remember about tests!)
5. Make your code better - for lazy programmers:

    ```
    $ ./docker/sniff-the-code-fixer.sh
    ```  
 
6. Sniff the code and detect mess:

    ```
    $ ./docker/sniff-the-code.sh
    $ ./docker/detect-mess.sh
    ``` 
7. Test:

       $ ./docker/php74.sh ./vendor/bin/phpunit
       or
       $ ./docker/test.sh
        
   Note that there are currently two testsuites: `Unit` and `Functional`. To use only single testsuite use `--testsuite` param like follows:

        $ ./docker/test.sh --testsuite Unit
   
8. Merge or create merge request.
9. Be happy PHP developer!