<?php

namespace Tests\Unit;

use FCAPoland\ApiPrivacyHelper\Cache\MemoryCache;
use FCAPoland\ApiPrivacyHelper\Exception\PrivacyHelperException;
use FCAPoland\ApiPrivacyHelper\PrivacyHelper;
use FCAPoland\ApiPrivacyHelper\Storage;
use FCAPoland\ApiPrivacyHelper\StorageInterface;
use PHPUnit\Framework\TestCase;
use Psr\SimpleCache\InvalidArgumentException;

/**
 * Class DisclaimerTest
 * @package Tests\Unit
 */
class DisclaimerTest extends TestCase
{
    /**
     * @var StorageInterface
     */
    private $storage;

    /**
     * @param $disclaimer_id
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testGetID($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);
        $this->assertEquals(
            $disclaimer_id,
            $privacy_helper->getDisclaimer()->getDisclaimerID()
        );
    }

    /**
     * @param $disclaimer_id
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testGetArray($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);
        $this->assertIsArray($privacy_helper->getDisclaimer()->getDisclaimerArray());
    }


    /**
     * @param $disclaimer_id
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerCreateAgreementsObject($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);
        $privacy_helper->setcache(new MemoryCache());

        $this->assertInstanceOf('\FCAPoland\ApiPrivacyHelper\Disclaimer\Agreements', $privacy_helper->getDisclaimer()->getAgreements());
    }

    /**
     * @param $disclaimer_id
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerGetAgreementsFormElements($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);

        $this->assertIsArray($privacy_helper->getDisclaimer()->getAgreements()->getFormElements());
    }

    /**
     * @param $disclaimer_id
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerGetAgreements($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);

        $this->assertIsString($privacy_helper->getDisclaimer()->getAgreements()->getIntroduction());
    }

    /**
     * @param $disclaimer_id
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerCreateGetRequiredFields($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);

        $this->assertIsArray($privacy_helper->getDisclaimer()->getAgreements()->requiredFields());
    }

    /**
     * @param $disclaimer_id
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerCreateInformactionObject($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);
        $privacy_helper->setcache(new MemoryCache());

        $this->assertInstanceOf('\FCAPoland\ApiPrivacyHelper\Disclaimer\Information', $privacy_helper->getDisclaimer()->getInformation());
    }

    /**
     * @param $disclaimer_id
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testDisclaimerGetInformactions($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);
        $privacy_helper->setcache(new MemoryCache());

        $this->assertIsArray($privacy_helper->getDisclaimer()->getInformation()->getInformations());
    }

    /**
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     */
    public function testDisclaimerGetInformactionsKeys()
    {
        $privacy_helper = new PrivacyHelper(723, $this->storage); // privacy-notes
        $privacy_helper->setcache(new MemoryCache());

        $this->assertIsArray($privacy_helper->getDisclaimer()->getInformation()->getInformationKeys());
    }

    /**
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     */
    public function testDisclaimerGetInformactionsPrivacyNotes()
    {
        $privacy_helper = new PrivacyHelper(723, $this->storage); // privacy-notes
        $privacy_helper->setcache(new MemoryCache());

        $this->assertIsString($privacy_helper->getDisclaimer()->getInformation()->getInformation('privacy-notes'));
    }

    /**
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     */
    public function testDisclaimerExceptionForIncorrectID()
    {
        $this->expectException(PrivacyHelperException::class);
        $privacy_helper = new PrivacyHelper(000, $this->storage);
        $privacy_helper->setcache(new MemoryCache());
        $disclaimer = $privacy_helper->getDisclaimer();
    }

    /**
     * @return array
     */
    public function additionProviderDataDisclaimers(): array
    {
        return [
            [723],
            [358],
            [645],
            [760]
        ];
    }

    protected function setUp(): void
    {
        parent::setUp();
        $this->storage = new Storage();
    }
}
