<?php

namespace Tests\Unit;

use FCAPoland\ApiPrivacyHelper\Exception\PrivacyHelperException;
use FCAPoland\ApiPrivacyHelper\Storage;
use PHPUnit\Framework\TestCase;

/**
 * Class StorageTest
 * @package Tests\Unit
 */
class StorageTest extends TestCase
{
    /**
     */
    public function testGeneralStorage()
    {
        $storage = new Storage();
        $storage->savePrivacyPolicy('abc', 'ABC');

        $this->assertIsString($storage->getPrivacyPolicy('abc'));
    }

    /**
     */
    public function testGeneralStorage2()
    {
        $storage = new Storage();

        $this->assertIsString($storage->getPrivacyPolicy('abc'));
    }

    /**
     * @throws PrivacyHelperException
     */
    public function testGeneralStorage3()
    {
        $storage = new Storage();

        $this->assertNull($storage->getPrivacyPolicy('no_data'));
    }

    /**
     */
    public function testGeneralStorage4()
    {
        $storage = new Storage();
        $storage->saveDisclaimer('abc', 'ABC');

        $this->assertIsString($storage->getDisclaimer('abc'));
    }

    /**
     */
    public function testGeneralStorage5()
    {
        $storage = new Storage();

        $this->assertIsString($storage->getDisclaimer('abc'));
    }

    /**
     */
    public function testGeneralStorage6()
    {
        $storage = new Storage();

        $this->assertNull($storage->getDisclaimer('no_data'));
    }

    /**
     * @param $key
     * @param $value
     * @dataProvider additionProviderDataIDs
     */
    public function testGeneral($key, $value)
    {
        $storage = new Storage();
        $storage->savePrivacyPolicy($key, $value);

        $this->assertIsString($storage->getPrivacyPolicy($key));
    }

    /**
     * @param $hash
     * @param $value
     * @dataProvider additionProviderDataPPHash
     */
    public function testGeneral2($hash, $value)
    {
        $storage = new Storage();
        $storage->saveDisclaimer($hash, $value);

        $this->assertIsString($storage->getPrivacyPolicy($hash));
    }

    /**
     * @param $key
     * @param $value
     * @dataProvider additionProviderDataIDs
     */
    public function testGeneral3($key, $value)
    {
        $storage = new Storage();

        $this->assertIsString($storage->getPrivacyPolicy($key));
    }

    /**
     * @param $hash
     * @param $value
     * @dataProvider additionProviderDataPPHash
     */
    public function testGeneral4($hash, $value)
    {
        $storage = new Storage();

        $this->assertIsString($storage->getPrivacyPolicy($hash));
    }

    /**
     * @param $id
     * @param $value
     * @dataProvider additionProviderDataIDs
     */
    public function testGeneral5($id, $value)
    {
        $storage = new Storage();

        $this->assertIsString($storage->getPrivacyPolicy($id));
    }

    /**
     * @param $hash
     * @param $value
     * @dataProvider additionProviderDataPPHash
     */
    public function testGeneral6($hash, $value)
    {
        $storage = new Storage();

        $storage->removeStorage();

        $this->assertNull($storage->getPrivacyPolicy($hash));
    }

    /**
     * @param $id
     * @param $value
     * @dataProvider additionProviderDataIDs
     */
    public function testGeneral7($id, $value)
    {
        $storage = new Storage();
        $storage->removeStorage();
        $this->assertNull($storage->getDisclaimer($id));
    }

    /**
     */
    public function testGeneral8()
    {
        $this->expectNotToPerformAssertions();
        $storage = new Storage();

        $storage->removeStorage();
        $storage->removeStorage();
    }

    /**
     * @return array
     */
    public function additionProviderDataPPHash(): array
    {
        return [
            ['22c68927b19e818e92067657b89f634509ed7385', 'XXX'],
            ['mBTRP8Bvn2JXveCyOmC8oGRYFdghAu2jdyLwhHAA', 'YYY'],
            ['43a3bacb1a1268127c7b60f52b1f8675793007c0', 'ZZZ']
        ];
    }

    /**
     * @return array
     */
    public function additionProviderDataIDs(): array
    {
        return [
            ['001', 'XXX'],
            ['002', 'YYY'],
            ['003', 'ZZZ']
        ];
    }
}
