<?php
declare(strict_types=1);


namespace FCAPoland\ApiPrivacyHelper;

use FCAPoland\ApiPrivacyHelper\Exception\PrivacyHelperException;

/**
 * Interface StorageInterface
 * @package FCAPoland\ApiPrivacyHelper
 */
interface StorageInterface
{

    /**
     * StorageInterface constructor.
     * @param null $storage_file
     */
    public function __construct($storage_file = null);

    /**
     * @param int $id
     * @param mixed $data
     */
    public function saveDisclaimer(int $id, $data);

    /**
     * @param int $id
     * @return mixed
     */
    public function getDisclaimer(int $id);

    /**
     * @param string $hash
     * @param mixed $data
     */
    public function savePrivacyPolicy(string $hash, $data);

    /**
     * @param string$hash
     * @return mixed
     */
    public function getPrivacyPolicy(string $hash);

    /**
     * @param string $form_and_brand_id
     * @param $data
     * @throws PrivacyHelperException
     */
    public function saveDealers(string $form_and_brand_id, $data);

    /**
     * @param string $form_and_brand_id
     * @return mixed
     */
    public function getDealers(string $form_and_brand_id);

    /**
     * @param string $key
     * @param $data
     * @throws PrivacyHelperException
     */
    public function saveToStorage(string $key, $data);

    /**
     * @param string $key
     * @return mixed|null
     */
    public function readFromStorage(string $key);

    /**
     * Remove storage file and clear storage
     */
    public function removeStorage();
}
