<?php

namespace Tests\Functional;

use FCAPoland\ApiPrivacyHelper\Cache\MemoryCache;
use FCAPoland\ApiPrivacyHelper\Exception\PrivacyHelperException;
use FCAPoland\ApiPrivacyHelper\PrivacyHelper;
use FCAPoland\ApiPrivacyHelper\Storage;
use FCAPoland\ApiPrivacyHelper\StorageInterface;
use PHPUnit\Framework\TestCase;
use Psr\SimpleCache\InvalidArgumentException;

class PrivacyHelperTest extends TestCase
{

    /** @var StorageInterface */
    private $storage;
    /**  @var int */
    private $disclaimer_id;
    /**  @var MemoryCache */
    private $cache;

    /**
     * @param $disclaimer_id
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testMain($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);
        $this->assertEquals(
            $disclaimer_id,
            $privacy_helper->getDisclaimer()->getDisclaimerID()
        );
    }

    /**
     * @param $disclaimer_id
     * @throws PrivacyHelperException
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataDisclaimers
     */
    public function testMain2($disclaimer_id)
    {
        $privacy_helper = new PrivacyHelper($disclaimer_id, $this->storage);
        $this->assertEquals(
            $disclaimer_id,
            $privacy_helper->getDisclaimer()->getDisclaimerID()
        );
    }

    /**
     * @return array
     */
    public function additionProviderDataDisclaimers()
    {
        return [
            [723],
            [358],
            [645]
        ];
    }

    protected function setUp(): void
    {
        parent::setUp();

        $this->disclaimer_id = 723;
        $this->cache = new MemoryCache();
        $this->storage = new Storage();
    }
}
