<?php

declare(strict_types=1);

namespace FCAPoland\ApiPrivacyHelper\Disclaimer;

use FCAPoland\ApiPrivacyHelper\Disclaimer;

/**
 * Class Information
 * @package FCAPoland\ApiPrivacyHelper\Disclaimer
 */
class Information
{
    /**
     * @var array
     */
    private $disclaimer;

    /**
     * Information constructor.
     * @param Disclaimer $disclaimer
     */
    public function __construct(Disclaimer $disclaimer)
    {
        $this->disclaimer = $disclaimer->getDisclaimerArray();
    }

    /**
     * @param string $key
     * @return string
     */
    public function getInformation(string $key): string
    {
        return $this->getInformations()[$key] ?? '';
    }

    /**
     * @return array
     */
    public function getInformations(): array
    {
        return $this->disclaimer['information'] ?? [];
    }

    /**
     * @param string $key
     * @return bool
     */
    public function hasInformation(string $key): bool
    {
        return array_key_exists($key, $this->getInformations());
    }

    /**
     * @return array
     */
    public function getInformationKeys(): array
    {
        return array_keys($this->getInformations());
    }
}
