<?php

namespace Tests\Unit;

use FCAPoland\ApiPrivacyHelper\Cache\MemoryCache;
use FCAPoland\ApiPrivacyHelper\PrivacyHelper;
use FCAPoland\ApiPrivacyHelper\Storage;
use FCAPoland\ApiPrivacyHelper\StorageInterface;
use PHPUnit\Framework\TestCase;
use Psr\SimpleCache\InvalidArgumentException;

/**
 * Class PrivacyPolicyTest
 * @package Tests\Unit
 */
class PrivacyPolicyTest extends TestCase
{
    /**
     * @var StorageInterface
     */
    private $storage;

    /**
     */
    public function testGeneralPrivacyPolicyHash()
    {
        $privacy_helper = new PrivacyHelper(723, $this->storage);

        $this->assertIsString($privacy_helper->getPrivacyPolicy()->getPrivacyPolicyHash());
    }

    /**
     * @param $hash
     * @dataProvider additionProviderDataPPHash
     */
    public function testSetPolicyHash($hash)
    {
        $privacy_helper = new PrivacyHelper(723, $this->storage);
        $privacy_helper->getPrivacyPolicy()->setPrivacyPolicyHash($hash);
        $this->assertEquals(
            $hash,
            $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyHash()
        );
    }

    /**
     * @throws InvalidArgumentException
     */
    public function testGeneralPrivacyPolicyContent()
    {
        $privacy_helper = new PrivacyHelper(723, $this->storage);

        $this->assertIsString($privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent());
    }

    /**
     * @param $hash
     * @dataProvider additionProviderDataPPHash
     */
    public function testCustomPrivacyPolicyHash($hash)
    {
        $privacy_helper = new PrivacyHelper(723, $this->storage);
        $privacy_helper->getPrivacyPolicy()->setPrivacyPolicyHash($hash);

        $this->assertIsString($privacy_helper->getPrivacyPolicy()->getPrivacyPolicyHash());
    }

    /**
     * @param $hash
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataPPHash
     */
    public function testCustomPrivacyPolicyContent($hash)
    {
        $privacy_helper = new PrivacyHelper(723, $this->storage);
        $privacy_helper->getPrivacyPolicy()->setPrivacyPolicyHash($hash);

        $this->assertIsString($privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent());
    }

    /**
     * @throws InvalidArgumentException
     */
    public function testGeneralPrivacyPolicyContentWithCache()
    {
        $privacy_helper = new PrivacyHelper(723, $this->storage);
        $privacy_helper->setcache(new MemoryCache());

        $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent();

        $this->assertIsString($privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent());
    }

    /**
     * @param $hash
     * @throws InvalidArgumentException
     * @dataProvider additionProviderDataPPHash
     */
    public function testCustomPrivacyPolicyContentWithCache($hash)
    {
        $privacy_helper = new PrivacyHelper(723, $this->storage);
        $privacy_helper->setcache(new MemoryCache());

        $privacy_helper->getPrivacyPolicy()->setPrivacyPolicyHash($hash);
        $privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent();

        $this->assertIsString($privacy_helper->getPrivacyPolicy()->getPrivacyPolicyContent());
    }

    /**
     * @return array
     */
    public function additionProviderDataPPHash(): array
    {
        return [
            ['22c68927b19e818e92067657b89f634509ed7385'],
            ['mBTRP8Bvn2JXveCyOmC8oGRYFdghAu2jdyLwhHAA'],
            ['43a3bacb1a1268127c7b60f52b1f8675793007c0']
        ];
    }

    protected function setUp(): void
    {
        parent::setUp();
        $this->storage = new Storage();
    }
}
