# api

API for accessing stock vehicles in different manners, including filtering and sorting.

# Examples
* Using Stock class to generate filters:
    ```php
    $client = new \MongoDB\Client('mongodb://db-stock:27017');
    $db = $client->selectDatabase('stock-www');

    Api::setDatabase($db);
    Api::setCollection('offers');

    $offerCollection = new Offer();

    $stock = new Stock();
    $stock->setBrandCode('00')->setModel('357');

    $sort = new Sort();
    $sort->addSortBy(Builder\Fields::BASE_PRICE_BRUTTO, Sort::ASC);

    $offers = $offerCollection->find($stock->getFilter(), $sort->getSort());
    ```

* Using Builder class to generate filters:
    ```php
    $client = new \MongoDB\Client('mongodb://db-stock:27017');
    $db = $client->selectDatabase('stock-www');

    Api::setDatabase($db);
    Api::setCollection('offers');

    $offerCollection = new Offer();

    $b = new Builder();

    $f = $b->andWhere(
        $b->is(Builder\Fields::FINAL_PRICE_NETTO, '>', 60000),
        $b->is(Builder\Fields::FINAL_PRICE_NETTO, '<', 80000)
    );

    $sort = new Sort();
    $sort->addSortBy(Builder\Fields::BASE_PRICE_BRUTTO, Sort::ASC);

    $offers = $offerCollection->find($f, $sort->getSort());
    ```
