<?php
/**
 * Created by PhpStorm.
 * Damian Banaszkiewicz <dbanaszkiewicz@unicorn.net.pl>
 * 23.08.18 11:45
 */

namespace FCA\StockApi\Collection\Filter\Builder;

class ValueTypes
{
    const STRING = ['string', 'NULL'];
    const INTEGER = ['integer', 'NULL'];
    const DOUBLE = ['double', 'float', 'integer', 'NULL'];
    const BOOLEAN = ['boolean', 'NULL'];
    const GEOMETRY = ['geometry'];

    private static $map = null;

    /**
     * @return array|bool
     */
    public static function getValueMap()
    {
        if (self::$map !== null) {
            return self::$map;
        } else {
            try {
                $reflect = new \ReflectionClass(Fields::class);
                $constants = $reflect->getConstants();
            } catch (\ReflectionException $e) {
                return false;
            }

            $map = [];

            $intFields = [
                Fields::ID,
                Fields::PRODUCTION_YEAR,
                Fields::ENGINE_POWER,
                Fields::GEARS,
            ];

            $doubleFields = [
                Fields::VERSION_PRICE,
                Fields::BASE_PRICE_NETTO,
                Fields::BASE_PRICE_BRUTTO,
                Fields::FINAL_PRICE_NETTO,
                Fields::FINAL_PRICE_BRUTTO,
                Fields::EQUIPMENT_PRICE,
                Fields::ENGINE_CAPACITY,
            ];

            $booleanFields = [
                Fields::IS_DEMO,
            ];

            $geometryFields = [
                Fields::DEALER_COORDINATES,
            ];

            foreach ($constants as $constant) {
                if (in_array($constant, $intFields)) {
                    $map[$constant] = self::INTEGER;
                } elseif (in_array($constant, $doubleFields)) {
                    $map[$constant] = self::DOUBLE;
                } elseif (in_array($constant, $booleanFields)) {
                    $map[$constant] = self::BOOLEAN;
                } elseif (in_array($constant, $geometryFields)) {
                    $map[$constant] = self::GEOMETRY;
                } else {
                    $map[$constant] = self::STRING;
                }
            }

            self::$map = null;

            return $map;
        }
    }
}
