<?php
/**
 * Created by PhpStorm.
 * Damian Banaszkiewicz <dbanaszkiewicz@unicorn.net.pl>
 * 22.08.18 11:13
 */

namespace FCA\StockApi\Collection;

use FCA\StockApi\Api;
use FCA\StockApi\Collection\Filter\Builder\Validator;
use FCA\StockApi\Collection\Sort\Sort;
use FCA\StockApi\Exception\ApiException;
use MongoDB\Driver\Cursor;

class Offer
{
    /**
     * @var \MongoDB\Collection
     */
    protected $offerCollection;

    /**
     * Offer constructor.
     * @throws ApiException
     */
    public function __construct()
    {
        if (Api::$collection === null) {
            throw new ApiException('Database collection is missing!');
        }

        $this->offerCollection = Api::$collection;
    }

    /**
     * @param array $filters
     * @param array|null $sort
     * @param int|null $limit
     * @param int|null $skip
     * @return \FCA\StockApi\Document\Offer[]
     * @throws ApiException
     */
    public function find($filters = [], $sort = null, $limit = null, $skip = null)
    {
        Validator::validateFilter($filters);

        $options = [];
        if ($sort != [] and $sort !== null) {
            if (!Validator::isValidSortArray($sort)) {
                throw new ApiException('Sort array is invalid!');
            }

            $options['collation'] = ['locale' => 'pl'];
            $options['sort'] = $sort;
        }

        if ($limit !== null) {
            if (is_int($limit)) {
                $options['limit'] = $limit;
            } else {
                throw new ApiException('Limit must be integer!');
            }
        }

        if ($skip !== null) {
            if (is_int($skip)) {
                $options['skip'] = $skip;
            } else {
                throw new ApiException('Skip must be integer!');
            }
        }

        $docs = $this->offerCollection->find($filters, $options);
        $ret = [];

        foreach ($docs as $doc) {
            $ret[] = new \FCA\StockApi\Document\Offer((array)$doc);
        }

        $docs = null;
        unset($docs);

        return $ret;
    }

    /**
     * @param array $filters
     * @param array|null $sort
     * @param int|null $skip
     * @return \FCA\StockApi\Document\Offer|null
     * @throws ApiException
     */
    public function findOne($filters = [], $sort = null, $skip = null)
    {
        Validator::validateFilter($filters);

        $options = [];
        if ($sort != [] and $sort !== null) {
            if (!Validator::isValidSortArray($sort)) {
                throw new ApiException('Sort array is invalid!');
            }

            $options['collation'] = ['locale' => 'pl'];
            $options['sort'] = $sort;
        }

        if ($skip !== null) {
            if (is_int($skip)) {
                $options['skip'] = $skip;
            } else {
                throw new ApiException('Skip must be integer!');
            }
        }


        $doc = $this->offerCollection->findOne($filters, $options);

        if (!$doc) {
            return null;
        }

        $offer = new \FCA\StockApi\Document\Offer((array)$doc);

        $doc = null;
        unset($doc);

        return $offer;
    }

    /**
     * @param $id
     * @return \FCA\StockApi\Document\Offer|null
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function findOneById($id)
    {
        $doc = $this->offerCollection->findOne(["vehicle_id" => $id]);

        if (!$doc) {
            return null;
        }

        $offer = new \FCA\StockApi\Document\Offer((array)$doc);

        $doc = null;
        unset($doc);

        return $offer;
    }
}
