<?php
/**
 * Created by PhpStorm.
 * Damian Banaszkiewicz <dbanaszkiewicz@unicorn.net.pl>
 * 22.08.18 11:27
 */

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Equipment extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $type;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var null|string
     */
    protected $price;

    /**
     * Equipment constructor.
     * @param $equipment
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($equipment)
    {
        $required_keys = ['code', 'type', 'name', 'price'];
        $this->checkKeys($required_keys, $equipment);

        $this->code = $equipment['code'];
        $this->type = $equipment['type'];
        $this->name = $equipment['name'];
        $this->price = $equipment['price'];
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return null|string
     */
    public function getPrice()
    {
        return $this->price;
    }
}
