<?php
/**
 * Created by PhpStorm.
 * Damian Banaszkiewicz <dbanaszkiewicz@unicorn.net.pl>
 * 22.08.18 11:16
 */

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Interior extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $type;

    /**
     * Interior constructor.
     * @param $interior
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($interior)
    {
        $required_keys = ['code', 'name', 'type'];
        $this->checkKeys($required_keys, $interior);

        $this->code = $interior['code'];
        $this->name = $interior['name'];
        $this->type = $interior['type'];
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }
}
