<?php
/**
 * Created by PhpStorm.
 * Damian Banaszkiewicz <dbanaszkiewicz@unicorn.net.pl>
 * 22.08.18 11:17
 */

namespace FCA\StockApi\Document\Offer\Price;

use FCA\StockApi\Document\Base;

class BasePrice extends Base
{
    /**
     * @var float
     */
    protected $netto;

    /**
     * @var float
     */
    protected $brutto;

    /**
     * BasePrice constructor.
     * @param $base
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($base)
    {
        $required_keys = ['netto', 'brutto'];
        $this->checkKeys($required_keys, $base);

        $this->netto = $base['netto'];
        $this->brutto = $base['brutto'];
    }

    /**
     * @return float
     */
    public function getNetto()
    {
        return $this->netto;
    }

    /**
     * @return float
     */
    public function getBrutto()
    {
        return $this->brutto;
    }
}
