<?php
/**
 * Created by PhpStorm.
 * Damian Banaszkiewicz <dbanaszkiewicz@unicorn.net.pl>
 * 22.08.18 11:18
 */

namespace FCA\StockApi\Document\Offer\Price;

use FCA\StockApi\Document\Base;

class FinalPrice extends Base
{
    /**
     * @var float
     */
    protected $netto;

    /**
     * @var float
     */
    protected $brutto;

    /**
     * FinalPrice constructor.
     * @param $final
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($final)
    {
        $required_keys = ['netto', 'brutto'];
        $this->checkKeys($required_keys, $final);

        $this->netto = $final['netto'];
        $this->brutto = $final['brutto'];
    }

    /**
     * @return float
     */
    public function getNetto()
    {
        return $this->netto;
    }

    /**
     * @return float
     */
    public function getBrutto()
    {
        return $this->brutto;
    }
}
