<?php
/**
 * Created by PhpStorm.
 * Damian Banaszkiewicz <dbanaszkiewicz@unicorn.net.pl>
 * 22.08.18 11:17
 */

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class TechnicalData extends Base
{
    /**
     * @var string
     */
    protected $vehicleType;

    /**
     * @var string
     */
    protected $fuelType;

    /**
     * @var string
     */
    protected $door;

    /**
     * @var string
     */
    protected $seats;

    /**
     * @var float
     */
    protected $engineCapacity;

    /**
     * @var string
     */
    protected $engineType;

    /**
     * @var int
     */
    protected $enginePower;

    /***
     * @var string
     */
    protected $averageFuelConsumption;

    /**
     * @var string
     */
    protected $bodyType;

    /**
     * @var string
     */
    protected $driveType;

    /**
     * @var string
     */
    protected $gearboxType;

    /**
     * @var string
     */
    protected $gears;

    /**
     * @var string
     */
    protected $equipmentLevel;

    /**
     * @var string
     */
    protected $emissionStandard;

    /**
     * @var string
     */
    protected $co2Emission;

    /**
     * TechnicalData constructor.
     * @param $technicalData
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($technicalData)
    {
        $required_keys = ['vehicle_type', 'fuel_type', 'door', 'seats', 'engine_capacity', 'engine_type',
            'engine_power', 'average_fuel_consumption', 'body_type', 'drive_type', 'gearbox_type', 'gears',
            'equipment_level', 'emission_standard', 'co2_emission'];
        $this->checkKeys($required_keys, $technicalData);

        $this->vehicleType = $technicalData['vehicle_type'];
        $this->fuelType = $technicalData['fuel_type'];
        $this->door = $technicalData['door'];
        $this->seats = $technicalData['seats'];
        $this->engineCapacity = $technicalData['engine_capacity'];
        $this->engineType = $technicalData['engine_type'];
        $this->enginePower = $technicalData['engine_power'];
        $this->averageFuelConsumption = $technicalData['average_fuel_consumption'];
        $this->bodyType = $technicalData['body_type'];
        $this->driveType = $technicalData['drive_type'];
        $this->gearboxType = $technicalData['gearbox_type'];
        $this->gears = $technicalData['gears'];
        $this->equipmentLevel = $technicalData['equipment_level'];
        $this->emissionStandard = $technicalData['emission_standard'];
        $this->co2Emission = $technicalData['co2_emission'];
    }

    /**
     * @return string
     */
    public function getVehicleType()
    {
        return $this->vehicleType;
    }

    /**
     * @return string
     */
    public function getFuelType()
    {
        return $this->fuelType;
    }

    /**
     * @return string
     */
    public function getDoor()
    {
        return $this->door;
    }

    /**
     * @return string
     */
    public function getSeats()
    {
        return $this->seats;
    }

    /**
     * @return float
     */
    public function getEngineCapacity()
    {
        return $this->engineCapacity;
    }

    /**
     * @return string
     */
    public function getEngineType()
    {
        return $this->engineType;
    }

    /**
     * @return int
     */
    public function getEnginePower()
    {
        return $this->enginePower;
    }

    /**
     * @return string
     */
    public function getAverageFuelConsumption()
    {
        return $this->averageFuelConsumption;
    }

    /**
     * @return string
     */
    public function getBodyType()
    {
        return $this->bodyType;
    }

    /**
     * @return string
     */
    public function getDriveType()
    {
        return $this->driveType;
    }

    /**
     * @return string
     */
    public function getGearboxType()
    {
        return $this->gearboxType;
    }

    /**
     * @return string
     */
    public function getGears()
    {
        return $this->gears;
    }

    /**
     * @return string
     */
    public function getEquipmentLevel()
    {
        return $this->equipmentLevel;
    }

    /**
     * @return string
     */
    public function getEmissionStandard()
    {
        return $this->emissionStandard;
    }

    /**
     * @return string
     */
    public function getCo2Emission()
    {
        return $this->co2Emission;
    }
}
