<?php
/**
 * Created by PhpStorm.
 * Damian Banaszkiewicz <dbanaszkiewicz@unicorn.net.pl>
 * 22.08.18 11:15
 */

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Version extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $commercialCode;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var array
     */
    protected $slug;

    /**
     * @var float
     */
    protected $price;

    /**
     * Version constructor.
     * @param $version
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($version)
    {
        $required_keys = ['code', 'commercial_code', 'name', 'slug', 'price'];
        $this->checkKeys($required_keys, $version);

        $this->code = $version['code'];
        $this->commercialCode = $version['commercial_code'];
        $this->name = $version['name'];
        $this->slug = $version['slug'];
        $this->price = $version['price'];
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getCommercialCode()
    {
        return $this->commercialCode;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return array
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }
}
