<?php
/**
 * Created by PhpStorm.
 * Damian Banaszkiewicz <dbanaszkiewicz@unicorn.net.pl>
 * 28.08.18 14:08
 */

namespace FCA\StockApi\Tests\Unit;

class ApiTest extends \PHPUnit\Framework\TestCase
{

    /**
     * Sprawdzenie działania metody setDatabase na poprawnych danych
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function testSetValidDatabase()
    {
        $client = new \MongoDB\Client('mongodb://db-stock:27017');
        $db = $client->selectDatabase('stock-www');

        $api = new \FCA\StockApi\Api();
        $api->setDatabase($db);

        $this->assertTrue(true);
    }

    /**
     * Sprawdzenie działania metody setDatabase na niepoprawnych danych
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function testSetInvalidDatabase()
    {
        $client = new \MongoDB\Client('mongodb://invalidHost:27017');
        $db = $client->selectDatabase('stock-www');

        $api = new \FCA\StockApi\Api();
        $this->expectException(\FCA\StockApi\Exception\ApiException::class);
        $api->setDatabase($db);
    }

    /**
     * Sprawdzenie działania metody setCollection na poprawnych danych
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function testSetValidCollection()
    {
        $client = new \MongoDB\Client('mongodb://db-stock:27017');
        $db = $client->selectDatabase('stock-www');

        $api = new \FCA\StockApi\Api();
        $api->setDatabase($db);
        $api->setCollection('offers');

        $this->assertTrue(true);
    }

    /**
     * Sprawdzenie działania metody setCollection na poprawnych danych
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function testSetInvalidCollection()
    {
        $client = new \MongoDB\Client('mongodb://db-stock:27017');
        $db = $client->selectDatabase('stock-www');

        $api = new \FCA\StockApi\Api();
        $api->setDatabase($db);
        $this->expectException(\FCA\StockApi\Exception\ApiException::class);
        $api->setCollection('badCollection');
    }
}
