# api

API for accessing stock vehicles in different manners, including filtering and sorting.

# Examples

### Get Collection
```php 
$api = new Api();
$api->setDatabase($db);
$api->setCollection('offers');
    
$offerCollection = new Offer($api);
```

### Define filters
* Using Stock class:
    ```php
    $stock = new Stock();
    $stock->setBrandCode('00')->setModel('357');
    
    $filters = $stock->getFilters();
       
    $sort = new Sort();
    $sort->addSortBy(Fields::BASE_PRICE_BRUTTO, Sort::ASC);
    ```

* Using Builder class:
    ```php
    $builder = new Builder();

    $filters = $builder->andWhere(
        $builder->is(Fields::FINAL_PRICE_NETTO, '>', 60000),
        $builder->is(Fields::FINAL_PRICE_NETTO, '<', 80000)
    );
    ```
* With your own array:
    ```php
    $filters = [
      Fields::FINAL_PRICE_NETTO => ['$gt' => 60000],
      Fields::FINAL_PRICE_NETTO => ['$lt' => 80000]
    ];
    ```

### Fetching data
* Find offers using filters only
    ```php
    $offers = $offerCollection->find($filters);
    ```
* Find sorted offers using filters
    ```php
    $sort = new Sort();
    $sort->addSortBy(Fields::BASE_PRICE_BRUTTO, Sort::ASC);
    $sort = $sort->getSort();
      
    $offers = $offerCollection->find($filters, $sort);
    ```  
* Find sorted offers with skip and limit args
    ```php    
    // find next 15 documents after first 5
    $skipFirst = 5;
    $limit = 15;
      
    $offers = $offerCollection->find($filters, null, $limit, $skipFirst);
    ```
* Find count of offers using filters
    ```php    
    $count = $offerCollection->count($filters);
    ```
* Find distinct values of offer field using filters
    ```php    
    $count = $offerCollection->findDistinct(Fields::BRAND_NAME, $filters);
    ```
