<?php

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Brand extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $slug;

    /**
     * Brand constructor.
     * @param $brand
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($brand)
    {
        $required_keys = ['code', 'name', 'slug'];
        $this->checkKeys($required_keys, $brand);

        $this->code = $brand['code'];
        $this->name = $brand['name'];
        $this->slug = $brand['slug'];
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getSlug()
    {
        return $this->slug;
    }
}
