<?php

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;
use FCA\StockApi\Document\Offer\Dealer\Coordinates;

class Dealer extends Base
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $email;

    /**
     * @var string
     */
    protected $street;

    /**
     * @var string
     */
    protected $postCode;

    /**
     * @var string
     */
    protected $city;

    /**
     * @var string
     */
    protected $region;

    /**
     * @var Coordinates
     */
    protected $coordinates;

    /**
     * @var string
     */
    protected $website;

    /**
     * Dealer constructor.
     * @param $dealer
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($dealer)
    {
        $required_keys = ['name', 'email', 'street', 'post_code', 'city', 'region', 'coordinates', 'website'];
        $this->checkKeys($required_keys, $dealer);

        $this->name = $dealer['name'];
        $this->email = $dealer['email'];
        $this->street = $dealer['street'];
        $this->postCode = $dealer['post_code'];
        $this->city = $dealer['city'];
        $this->region = $dealer['region'];
        $coordinates = (array)$dealer['coordinates'];
        $this->coordinates = new Coordinates((array)$coordinates['coordinates']);
        $this->website = $dealer['website'];
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * @return string
     */
    public function getPostCode()
    {
        return $this->postCode;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * @return Coordinates
     */
    public function getCoordinates()
    {
        return $this->coordinates;
    }

    /**
     * @return string
     */
    public function getWebsite()
    {
        return $this->website;
    }
}
