<?php

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;
use FCA\StockApi\Document\Offer\Price\BasePrice;
use FCA\StockApi\Document\Offer\Price\FinalPrice;

class Price extends Base
{
    /**
     * @var BasePrice
     */
    protected $base;

    /**
     * @var FinalPrice
     */
    protected $final;

    /**
     * Price constructor.
     * @param $price
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($price)
    {
        $required_keys = ['base', 'final'];
        $this->checkKeys($required_keys, $price);

        $this->base = new BasePrice((array)$price['base']);
        $this->final = new FinalPrice((array)$price['final']);
    }

    /**
     * @return BasePrice
     */
    public function getBase()
    {
        return $this->base;
    }

    /**
     * @return FinalPrice
     */
    public function getFinal()
    {
        return $this->final;
    }
}
