#!/usr/bin/env bash

docker exec stock-mongo true 2>/dev/null
status=$?

# Jeśli kontenery dockera nie były uruchomione - uruchamiamy je...
if [ "$status" -eq 1 ]
then
printf '\033[0;32mStarting docker containers...\033[0m\n'
docker-compose up -d >/dev/null
echo ""
echo ""
fi

# Testy PHPUnit
docker exec -it stock-php php vendor/bin/phpunit

ex_status=$?

# Jeśli kontenery dockera nie były uruchomione - zatrzymujemy je...
if [ "$status" -eq 1 ]
then
printf '\033[0;32mStopping docker containers...\033[0m\n'
docker-compose down >/dev/null
fi

# Zwracamy exit status polecenia wykonującego testy
exit $ex_status