<?php

namespace FCA\StockApi\Collection\Filter\Builder;

class Fields
{
    const ID = 'vehicle_id'; // int

    const BRAND_CODE = 'brand.code';
    const BRAND_NAME = 'brand.name';
    const BRAND_SLUG = 'brand.slug';

    const MODEL_CODE = 'model.code';
    const MODEL_COMMERCIAL_CODE = 'model.commercial_code';
    const MODEL_NAME = 'model.name';

    const VERSION_CODE = 'version.code';
    const VERSION_COMMERCIAL_CODE = 'version.commercial_code';
    const VERSION_NAME = 'version.name';
    const VERSION_SLUG = 'version.slug';
    const VERSION_PRICE = 'version.price'; // double

    const SERIES_CODE = 'series.code';
    const SERIES_SPECIAL_CODE = 'series.special_code';

    const DEALER = 'dealer';
    const DEALER_CODE = 'dealer.code';
    const DEALER_SITECODE = 'dealer.sitecode';
    const DEALER_NAME = 'dealer.name';
    const DEALER_EMAIL = 'dealer.email';
    const DEALER_STREET = 'dealer.street';
    const DEALER_POST_CODE = 'dealer.post_code';
    const DEALER_CITY = 'dealer.city';
    const DEALER_REGION = 'dealer.region';
    const DEALER_COORDINATES = 'dealer.coordinates'; // geometry
    const DEALER_WEBSITE = 'dealer.website';
    const DEALER_PHONES = 'dealer.phones';

    const STATUS = 'status';

    const BASE_PRICE_NETTO = 'price.base.netto'; // double
    const BASE_PRICE_BRUTTO = 'price.base.brutto'; // double
    const FINAL_PRICE_NETTO = 'price.final.netto'; // double
    const FINAL_PRICE_BRUTTO = 'price.final.brutto'; // double

    const IS_DEMO = 'is_demo';

    const PRODUCTION_YEAR = 'year_of_production'; // int
    const PRODUCTION_DATE = 'date_of_production';

    const SINCOM = 'sincom';

    const STAMPS = 'stamps';

    const COLOR_CODE = 'color.code';
    const COLOR_CATEGORY = 'color.category';
    const COLOR_TYPE = 'color.type';
    
    const INTERIOR_CODE = 'interior.code';
    const INTERIOR_NAME = 'interior.name';
    const INTERIOR_TYPE = 'interior.type';

    const DESCRIPTION = 'description';

    const SERIAL_NO = 'serial_no';

    const LABELS = 'labels';

    const EQUIPMENT_CODE = 'equipment.code';
    const EQUIPMENT_TYPE = 'equipment.type';
    const EQUIPMENT_NAME = 'equipment.name';
    const EQUIPMENT_PRICE = 'equipment.price'; // double | null

    const VEHICLE_TYPE = 'technical_data.vehicle_type';
    const FUEL_TYPE = 'technical_data.fuel_type';
    const DOOR = 'technical_data.door';
    const SEATS = 'technical_data.seats';
    const ENGINE_CAPACITY = 'technical_data.engine_capacity'; // double
    const ENGINE_POWER = 'technical_data.engine_power'; // int
    const AVERAGE_FUEL_CONSUMPTION = 'technical_data.average_fuel_consumption';
    const BODY_TYPE = 'technical_data.body_type';
    const DRIVE_TYPE = 'technical_data.drive_type';
    const GEARBOX_TYPE = 'technical_data.gearbox_type';
    const GEARS = 'technical_data.gears'; // int
    const EQUIPMENT_LEVEL = 'technical_data.equipment_level';
    const EMISSION_STANDARD = 'technical_data.emission_standard';
    const CO2_EMISSION = 'technical_data.co2_emission';
}
