<?php

namespace FCA\StockApi\Document\Offer\Dealer;

use FCA\StockApi\Document\Base;

class Coordinates extends Base
{
    /**
     * @var string
     */
    protected $longitude;

    /**
     * @var string
     */
    protected $latitude;

    /**
     * Coordinates constructor.
     * @param $coordinates
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($coordinates)
    {
        $requiredKeys = [0, 1];
        $this->checkKeys($requiredKeys, $coordinates);

        $this->longitude = $coordinates[0];
        $this->latitude = $coordinates[1];
    }

    /**
     * @return string
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * @return string
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
}
