<?php

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Interior extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $type;

    /**
     * Interior constructor.
     * @param $interior
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($interior)
    {
        $requiredKeys = ['code', 'name', 'type'];
        $this->checkKeys($requiredKeys, $interior);

        $this->code = $interior['code'];
        $this->name = $interior['name'];
        $this->type = $interior['type'];
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }

    public function toArray()
    {
        return [
            'code' => $this->getCode(),
            'name' => $this->getName(),
            'type' => $this->getType()
        ];
    }
}
