<?php

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Model extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $commercialCode;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var array
     */
    protected $groups;

    /**
     * Model constructor.
     * @param $model
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($model)
    {
        $requiredKeys = ['code', 'commercial_code', 'name', 'groups'];
        $this->checkKeys($requiredKeys, $model);

        $this->code = $model['code'];
        $this->commercialCode = $model['commercial_code'];
        $this->name = $model['name'];
        $this->groups = (array)$model['groups'];
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getCommercialCode()
    {
        return $this->commercialCode;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return array
     */
    public function getGroups()
    {
        return $this->groups;
    }

    public function toArray()
    {
        return [
            'code' => $this->getCode(),
            'commercialCode' => $this->getCommercialCode(),
            'name' => $this->getName(),
            'groups' => $this->getGroups()
        ];
    }
}
