<?php

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;
use FCA\StockApi\Document\Offer\Price\PriceDetails;

class Price extends Base
{
    /**
     * @var PriceDetails
     */
    protected $base;

    /**
     * @var PriceDetails
     */
    protected $final;

    /**
     * Price constructor.
     * @param $price
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($price)
    {
        $requiredKeys = ['base', 'final'];
        $this->checkKeys($requiredKeys, $price);

        $this->base = new PriceDetails((array)$price['base']);
        $this->final = new PriceDetails((array)$price['final']);
    }

    /**
     * @return PriceDetails
     */
    public function getBase()
    {
        return $this->base;
    }

    /**
     * @return PriceDetails
     */
    public function getFinal()
    {
        return $this->final;
    }

    public function toArray()
    {
        return [
            'base' => $this->getBase()->toArray(),
            'final' => $this->getFinal()->toArray(),
        ];
    }
}
