<?php

namespace FCA\StockApi\Document;

use FCA\StockApi\Exception\ApiException;

abstract class Base
{
    /**
     * @param $requiredKeys
     * @param $inputData
     * @throws ApiException
     */
    protected function checkKeys($requiredKeys, $inputData)
    {
        foreach ($requiredKeys as $key) {
            if (!array_key_exists($key, $inputData)) {
                throw new ApiException('Key: "' . $key . '" is undefined!"');
            }
        }
    }

    /**
     * @return array
     */
    abstract public function toArray();
}
