<?php

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Color extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $category;

    /**
     * @var string
     */
    protected $type;

    /**
     * Color constructor.
     * @param $color
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($color)
    {
        $requiredKeys = ['code', 'name', 'category', 'type'];
        $this->checkKeys($requiredKeys, $color);

        $this->code = $color['code'];
        $this->name = $color['name'];
        $this->category = $color['category'];
        $this->type = $color['type'];
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return null
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * @return null
     */
    public function getType()
    {
        return $this->type;
    }

    public function toArray()
    {
        return [
            'code' => $this->getCode(),
            'name' => $this->getName(),
            'category' => $this->getCategory(),
            'type' => $this->getType()
        ];
    }
}
