<?php

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;
use FCA\StockApi\Document\Offer\Dealer\Coordinates;

class Dealer extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $sitecode;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $email;

    /**
     * @var string
     */
    protected $street;

    /**
     * @var string
     */
    protected $postCode;

    /**
     * @var string
     */
    protected $city;

    /**
     * @var string
     */
    protected $region;

    /**
     * @var Coordinates
     */
    protected $coordinates;

    /**
     * @var string
     */
    protected $website;

    /**
     * @var string[]
     */
    protected $phones;
    /**
     * Dealer constructor.
     * @param $dealer
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($dealer)
    {
        $requiredKeys = ['code', 'sitecode', 'name', 'email', 'street', 'post_code', 'city', 'region', 'coordinates', 'website', 'phones'];
        $this->checkKeys($requiredKeys, $dealer);

        $this->code = $dealer['code'];
        $this->sitecode = $dealer['sitecode'];
        $this->name = $dealer['name'];
        $this->email = $dealer['email'];
        $this->street = $dealer['street'];
        $this->postCode = $dealer['post_code'];
        $this->city = $dealer['city'];
        $this->region = $dealer['region'];
        $coordinates = (array)$dealer['coordinates'];
        $this->coordinates = new Coordinates((array)$coordinates['coordinates']);
        $this->website = $dealer['website'];
        $this->phones = (array)$dealer['phones'];
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getSitecode()
    {
        return $this->sitecode;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * @return string
     */
    public function getPostCode()
    {
        return $this->postCode;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * @return Coordinates
     */
    public function getCoordinates()
    {
        return $this->coordinates;
    }

    /**
     * @return string
     */
    public function getWebsite()
    {
        return $this->website;
    }

    /**
     * @return string[]
     */
    public function getPhones()
    {
        return $this->phones;
    }

    public function toArray()
    {
        return [
            'code' => $this->getCode(),
            'sitecode' => $this->getSitecode(),
            'name' => $this->getName(),
            'email' => $this->getEmail(),
            'street' => $this->getStreet(),
            'postCode' => $this->getPostCode(),
            'city' => $this->getCity(),
            'region' => $this->getRegion(),
            'coordinates' => $this->getCoordinates()->toArray(),
            'website' => $this->getWebsite(),
            'phones' => $this->getPhones()
        ];
    }
}
