<?php

namespace FCA\StockApi\Document;

class DistinctValue extends Base
{
    /**
     * @var mixed
     */
    protected $value;

    /**
     * @var int
     */
    protected $count;

    /**
     * DistinctValue constructor.
     * @param mixed $value
     * @param int $count
     */
    public function __construct($value, $count)
    {
        $this->value = $value;
        $this->count = $count;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @return int
     */
    public function getCount()
    {
        return $this->count;
    }

    public function toArray()
    {
        return [
            'value' => $this->getValue(),
            'count' => $this->getCount()
        ];
    }
}
