<?php

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Series extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $specialCode;

    /**
     * Series constructor.
     * @param $series
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($series)
    {
        $requiredKeys = ['code', 'special_code'];
        $this->checkKeys($requiredKeys, $series);

        $this->code = $series['code'];
        $this->specialCode = $series['special_code'];
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getSpecialCode()
    {
        return $this->specialCode;
    }

    public function toArray()
    {
        return [
            'code' => $this->getCode(),
            'specialCode' => $this->getSpecialCode()
        ];
    }
}
