<?php

namespace FCA\StockApi\Document\Offer\Price;

use FCA\StockApi\Document\Base;

class PriceDetails extends Base
{
    /**
     * @var float
     */
    protected $netto;

    /**
     * @var float
     */
    protected $brutto;

    /**
     * FinalPrice constructor.
     * @param $price
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function __construct($price)
    {
        $requiredKeys = ['netto', 'brutto'];
        $this->checkKeys($requiredKeys, $price);

        $this->netto = $price['netto'];
        $this->brutto = $price['brutto'];
    }

    /**
     * @return float
     */
    public function getNetto()
    {
        return $this->netto;
    }

    /**
     * @return float
     */
    public function getBrutto()
    {
        return $this->brutto;
    }

    public function toArray()
    {
        return [
            'netto' => $this->getNetto(),
            'brutto' => $this->getBrutto()
        ];
    }
}
