<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Version extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $commercialCode;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var array
     */
    protected $slug;

    /**
     * @var float
     */
    protected $price;

    public function __construct(string $code, string $commercial_code, string $name, string $slug, float $price)
    {
        $this->code = $code;
        $this->commercialCode = $commercial_code;
        $this->name = $name;
        $this->slug = $slug;
        $this->price = $price;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getCommercialCode(): string
    {
        return $this->commercialCode;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    public function getPrice(): float
    {
        return $this->price;
    }

    public function toArray(): array
    {
        return [
            'code' => $this->getCode(),
            'commercialCode' => $this->getCommercialCode(),
            'name' => $this->getName(),
            'slug' => $this->getSlug(),
            'price' => $this->getPrice()
        ];
    }
}
