<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Equipment extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $type;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var null|float
     */
    protected $price;

    public function __construct(string $code, string $type, string $name, ?float $price = null)
    {
        $this->code = $code;
        $this->type = $type;
        $this->name = $name;
        $this->price = $price;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getPrice(): ?float
    {
        return $this->price;
    }

    public function toArray(): array
    {
        return [
            'code' => $this->getCode(),
            'name' => $this->getName(),
            'type' => $this->getType(),
            'price' => $this->getPrice()
        ];
    }
}
